/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.Logger;
import com.ibm.hwmca.fw.log.MicrocodeLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class HException
extends Exception {
    private static final boolean MYDEBUG = false;
    private static final String TRACE_MASKT = "XFRMHEXT";
    private static final String TRACE_MASKF = "XFRMHEXF";
    private static final String TRACE_MASKD = "XFRMHEXD";
    private boolean isLogged = false;
    private ArrayList dataBlocks = new ArrayList();
    private int[] traceBufferIds = new int[]{1, 2, 3};
    static /* synthetic */ Class class$com$ibm$hwmca$fw$log$FrameworkClassLogInfo;

    public HException(String text) {
        super(text);
        Trace.trace(TRACE_MASKT, "-> HException.HException(" + text + ")");
        this.addTraceBlocks();
        Trace.trace(TRACE_MASKT, "<- HException.HException(text)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HException(Throwable thrown) {
        super(thrown);
        Trace.trace(TRACE_MASKT, "-> HException.HException(thrown)");
        if (thrown instanceof HException) {
            this.setLogged(((HException)thrown).isLogged());
            ArrayList arrayList = this.dataBlocks;
            synchronized (arrayList) {
                this.dataBlocks.addAll(((HException)thrown).dataBlocks);
            }
        } else {
            this.addTraceBlocks();
        }
        Trace.trace(TRACE_MASKT, "<- HException.HException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HException(String text, Throwable thrown) {
        super(text, thrown);
        Trace.trace(TRACE_MASKT, "-> HException.HException(" + text + ", thrown)");
        if (thrown instanceof HException) {
            this.setLogged(((HException)thrown).isLogged());
            ArrayList arrayList = this.dataBlocks;
            synchronized (arrayList) {
                this.dataBlocks.addAll(((HException)thrown).dataBlocks);
            }
        } else {
            this.addTraceBlocks();
        }
        Trace.trace(TRACE_MASKT, "<- HException.HException(text, thrown)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HException(byte[] serializedCException) {
        super(HException.parseText(serializedCException));
        Trace.trace(TRACE_MASKT, "-> HException.HException(byte[])");
        boolean blockIx = false;
        String text = "";
        ParsedData parsedData = new ParsedData();
        SerializedBlock exceptionBlock = new SerializedBlock(serializedCException, 0);
        if (exceptionBlock.getType() != 32768) {
            Trace.trace(TRACE_MASKF, "Invalid data type (got " + exceptionBlock.getType() + ", expecting " + 32768 + ")");
        } else if (exceptionBlock.getFormat() != 1) {
            Trace.trace(TRACE_MASKF, "Invalid data format (got " + exceptionBlock.getFormat() + ", expecting 1)");
        } else {
            this.parseXBaseException(new SerializedBlock(exceptionBlock.getData(), 0), parsedData);
        }
        if (parsedData.backTrace.length() > 0 || parsedData.locationInfo.length() > 0) {
            if (parsedData.backTrace.length() > 0 && parsedData.locationInfo.length() > 0) {
                parsedData.backTrace = parsedData.backTrace + "\n";
            }
            parsedData.backTrace = parsedData.backTrace + parsedData.locationInfo;
            LogBlock logBlock = new LogBlock(-1, parsedData.backTrace, null);
            ArrayList arrayList = this.dataBlocks;
            synchronized (arrayList) {
                this.dataBlocks.add(0, logBlock);
            }
        }
        if (parsedData.owned && !this.isLogged() && parsedData.log != null) {
            boolean error = (parsedData.attributes & 0x100L) != 0L;
            boolean modifyBlock = (parsedData.attributes & 0x400L) != 0L;
            boolean displayAsError = (parsedData.attributes & 0x800L) != 0L;
            boolean omitThreadTrace = (parsedData.attributes & 0x2000L) != 0L;
            boolean omitProcessTrace = (parsedData.attributes & 0x4000L) != 0L;
            boolean omitFullTrace = (parsedData.attributes & 0x8000L) != 0L;
            byte restart = 0;
            if ((parsedData.attributes & 0x1000L) != 0L) {
                restart = 1;
            } else if ((parsedData.attributes & 0x80L) != 0L) {
                restart = 2;
            }
            MicrocodeLogAttributes logAttributes = new MicrocodeLogAttributes(error, modifyBlock, displayAsError, !omitFullTrace, !omitProcessTrace, !omitThreadTrace, false, restart);
            parsedData.log.setThrowable(this);
            parsedData.log.log(logAttributes);
        }
        Trace.trace(TRACE_MASKT, "<- HException.HException(byte[])");
    }

    public boolean isLogged() {
        return this.isLogged;
    }

    public void setLogged(boolean isLogged) {
        this.isLogged = isLogged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogBlock[] getDataBlocks() {
        LogBlock[] result = null;
        ArrayList arrayList = this.dataBlocks;
        synchronized (arrayList) {
            result = new LogBlock[this.dataBlocks.size()];
            this.dataBlocks.toArray(result);
        }
        return result;
    }

    public void add(Object data) {
        this.add((byte)-1, data, null);
    }

    public void add(byte blockId, Object data) {
        this.add(blockId, data, null);
    }

    public void add(Object data, ObjectDumperAttributes dumpAttribs) {
        this.add((byte)-1, data, dumpAttribs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte blockId, Object data, ObjectDumperAttributes dumpAttribs) {
        Trace.trace(TRACE_MASKF, "-> add(blockId=0x" + HexString.toHex(blockId, true) + ",data,dumpAttribs=" + dumpAttribs + ")");
        LogBlock logBlock = new LogBlock(blockId, data, dumpAttribs);
        ArrayList arrayList = this.dataBlocks;
        synchronized (arrayList) {
            this.dataBlocks.add(logBlock);
        }
        Trace.trace(TRACE_MASKF, "<- add()");
    }

    private void addTraceBlocks() {
        try {
            Trace.trace(TRACE_MASKD, "-> HException.addTraceBlocks()");
            if (CommonSystem.getCommonSystem().isLocationUnified() || CommonSystem.getCommonSystem().isLocationServer() || !(this instanceof TaskletException)) {
                Logger logger = Logger.getLogger();
                String[] traceBuffers = logger.getTraces(this.traceBufferIds);
                this.add((byte)-17, traceBuffers[0], null);
                this.add((byte)-18, traceBuffers[1], null);
                this.add((byte)-19, traceBuffers[2], null);
            }
        }
        catch (Throwable exc) {
            Trace.trace(TRACE_MASKF, "Error adding trace blocks");
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKD, "<- HException.addTraceBlocks()");
    }

    private static String parseText(byte[] serializedCException) {
        Trace.trace(TRACE_MASKT, "-> HException.parseText(byte[])");
        String text = "";
        int blockIx = 0;
        SerializedBlock exceptionBlock = new SerializedBlock(serializedCException, 0);
        if (exceptionBlock.getType() != 32768) {
            Trace.trace(TRACE_MASKF, "Invalid XException block type (got " + exceptionBlock.getType() + ", expecting " + 32768 + ")");
        } else if (exceptionBlock.getFormat() != 1) {
            Trace.trace(TRACE_MASKF, "Invalid XException block format (got " + exceptionBlock.getFormat() + ", expecting 1)");
        } else {
            SerializedBlock baseExceptionBlock = new SerializedBlock(exceptionBlock.getData(), 0);
            if (baseExceptionBlock.getType() != 32776) {
                Trace.trace(TRACE_MASKF, "Invalid XBaseException block type (got " + baseExceptionBlock.getType() + ", expecting " + 32776 + ")");
            } else if (baseExceptionBlock.getFormat() != 1) {
                Trace.trace(TRACE_MASKF, "Invalid XBaseException block format (got " + baseExceptionBlock.getFormat() + ", expecting 1)");
            } else {
                while (blockIx < baseExceptionBlock.getData().length) {
                    SerializedBlock baseExceptionSubblock = new SerializedBlock(baseExceptionBlock.getData(), blockIx);
                    if (baseExceptionSubblock.getType() == 1) {
                        if (baseExceptionSubblock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XBaseException text block format (got " + baseExceptionSubblock.getFormat() + ", expecting 1)");
                        } else {
                            text = new String(baseExceptionSubblock.getData(), 0, baseExceptionSubblock.getData().length - 1);
                            break;
                        }
                    }
                    blockIx = (int)((long)blockIx + baseExceptionSubblock.getSize());
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- HException.parseText(returns " + text + ")");
        return text;
    }

    private void parseXBaseException(SerializedBlock block, ParsedData parsedData) {
        Trace.trace(TRACE_MASKT, "-> HException.parseXBaseException(" + block + ")");
        String text = "";
        if (block.getType() != 32776) {
            Trace.trace(TRACE_MASKF, "Invalid XBaseException block type (got " + block.getType() + ", expecting " + 32776 + ")");
        } else if (block.getFormat() != 1) {
            Trace.trace(TRACE_MASKF, "Invalid XBaseException block format (got " + block.getFormat() + ", expecting 1)");
        } else {
            int subBlockIx = 0;
            while (subBlockIx < block.getData().length) {
                SerializedBlock subBlock = new SerializedBlock(block.getData(), subBlockIx);
                switch (subBlock.getType()) {
                    case 0: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XBaseException base block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        byte[] data = subBlock.getData();
                        boolean isLogged = data[32] != 0;
                        this.setLogged(isLogged);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XBaseException location block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        int locSubBlockIx = 0;
                        String fileName = null;
                        String funcName = null;
                        long locLine = 0L;
                        while (locSubBlockIx < subBlock.getData().length) {
                            SerializedBlock locationBlock = new SerializedBlock(subBlock.getData(), locSubBlockIx);
                            switch (locationBlock.getType()) {
                                case 3: {
                                    if (subBlock.getFormat() != 1) {
                                        Trace.trace(TRACE_MASKF, "Invalid XBaseException location file block format (got " + subBlock.getFormat() + ", expecting 1)");
                                        break;
                                    }
                                    fileName = new String(locationBlock.getData(), 0, locationBlock.getData().length - 1);
                                    break;
                                }
                                case 4: {
                                    if (subBlock.getFormat() != 1) {
                                        Trace.trace(TRACE_MASKF, "Invalid XBaseException locaction function block format (got " + subBlock.getFormat() + ", expecting 1)");
                                        break;
                                    }
                                    funcName = new String(locationBlock.getData(), 0, locationBlock.getData().length - 1);
                                    break;
                                }
                                case 5: {
                                    if (subBlock.getFormat() != 1) {
                                        Trace.trace(TRACE_MASKF, "Invalid XBaseException location line block format (got " + subBlock.getFormat() + ", expecting 1)");
                                        break;
                                    }
                                    locLine = BinaryNumber.toUnsignedInt(locationBlock.getData());
                                    break;
                                }
                                default: {
                                    Trace.trace(TRACE_MASKF, "Unknown XBaseException location data type (" + locationBlock.getType() + ")");
                                }
                            }
                            locSubBlockIx = (int)((long)locSubBlockIx + locationBlock.getSize());
                        }
                        if (parsedData.locationInfo.length() == 0) {
                            parsedData.locationInfo = "C Exception Location Information";
                        }
                        parsedData.locationInfo = parsedData.locationInfo + "\nat File: " + fileName + "\n   Func: " + funcName + "\n   Line: " + locLine;
                        break;
                    }
                    case 32772: 
                    case 32775: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XBaseException XEnd/XBoebMicrocodeLog block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        String logClassName = null;
                        logClassName = subBlock.getType() == 32772 ? "com.ibm.hwmca.z.log.EndZMicrocodeLog" : "com.ibm.hwmca.z.log.BoeMicrocodeLog";
                        try {
                            Class<?> logClass = Class.forName(logClassName);
                            Constructor<?> ctor = logClass.getConstructor(class$com$ibm$hwmca$fw$log$FrameworkClassLogInfo == null ? HException.class$("com.ibm.hwmca.fw.log.FrameworkClassLogInfo") : class$com$ibm$hwmca$fw$log$FrameworkClassLogInfo, Short.TYPE);
                            parsedData.log = (MicrocodeLog)ctor.newInstance(new FrameworkClassLogInfo(0, null), new Short(0));
                            this.parseXMicrocodeLog(new SerializedBlock(subBlock.getData(), 0), parsedData);
                        }
                        catch (Exception exc) {
                            Trace.trace(TRACE_MASKF, "Error instantiating log object");
                            Trace.trace(TRACE_MASKF, exc);
                        }
                        break;
                    }
                    default: {
                        Trace.trace(TRACE_MASKF, "Unknown XBaseException block type (" + subBlock.getType() + ")");
                    }
                }
                subBlockIx = (int)((long)subBlockIx + subBlock.getSize());
            }
        }
        Trace.trace(TRACE_MASKT, "<- HException.parseXBaseException()");
    }

    private void parseXMicrocodeLog(SerializedBlock block, ParsedData parsedData) {
        Trace.trace(TRACE_MASKT, "-> HException.parseXMicrocodeLog(" + block + ")");
        if (block.getType() != 32771) {
            Trace.trace(TRACE_MASKF, "Invalid XMicrocodeLog type (got " + block.getType() + ", expecting " + 32771 + ")");
        } else if (block.getFormat() < 1 || block.getFormat() > 2) {
            Trace.trace(TRACE_MASKF, "Invalid XMicrocodeLog format (got " + block.getFormat() + ", expecting 1 or 2)");
        } else {
            int subBlockIx = 0;
            while (subBlockIx < block.getData().length) {
                SerializedBlock subBlock = new SerializedBlock(block.getData(), subBlockIx);
                switch (subBlock.getType()) {
                    case 32770: {
                        this.parseXLog(subBlock, parsedData);
                        break;
                    }
                    case 0: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XMicrocodeLog base block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        byte[] baseData = subBlock.getData();
                        byte[] errorIdData = new byte[]{baseData[1], baseData[0]};
                        short errorId = BinaryNumber.toShort(errorIdData);
                        parsedData.log.setErrorId(errorId);
                        byte[] errorReasonData = new byte[]{baseData[5], baseData[4], baseData[3], baseData[2]};
                        int errorReason = BinaryNumber.toInt(errorReasonData);
                        parsedData.log.setErrorReason(errorReason);
                        if (subBlock.getFormat() <= 1) break;
                        parsedData.owned = baseData[6] != 0;
                        break;
                    }
                    case 1: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XMicrocodeLog text block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        String text = new String(subBlock.getData(), 0, subBlock.getData().length - 1);
                        this.add(text);
                        break;
                    }
                    case 2: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XMicrocodeLog backtrace block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        parsedData.backTrace = new String(subBlock.getData(), 0, subBlock.getData().length - 1);
                        break;
                    }
                    default: {
                        Trace.trace(TRACE_MASKF, "Unknown XMicrocodeLog block type (" + subBlock.getType() + ")");
                    }
                }
                subBlockIx = (int)((long)subBlockIx + subBlock.getSize());
            }
        }
        Trace.trace(TRACE_MASKT, "<- HException.parseXMicrocodeLog()");
    }

    private void parseXLog(SerializedBlock block, ParsedData parsedData) {
        Trace.trace(TRACE_MASKT, "-> HException.parseXLog(" + block + ")");
        if (block.getType() != 32770) {
            Trace.trace(TRACE_MASKF, "Invalid XLog type (got " + block.getType() + ", expecting " + 32770 + ")");
        } else if (block.getFormat() != 1) {
            Trace.trace(TRACE_MASKF, "Invalid XLog block format (got " + block.getFormat() + ", expecting 1)");
        } else {
            int subBlockIx = 0;
            while (subBlockIx < block.getData().length) {
                SerializedBlock subBlock = new SerializedBlock(block.getData(), subBlockIx);
                switch (subBlock.getType()) {
                    case 0: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XLog base block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        byte[] subBlockData = subBlock.getData();
                        byte logClass = subBlockData[0];
                        byte logType = subBlockData[1];
                        byte[] userData = new byte[]{subBlockData[3], subBlockData[2]};
                        short user = BinaryNumber.toShort(userData);
                        byte[] attrData = new byte[]{subBlockData[7], subBlockData[6], subBlockData[5], subBlockData[4]};
                        parsedData.attributes = BinaryNumber.toUnsignedInt(attrData);
                        parsedData.log.setLogClass(logClass);
                        parsedData.log.setLogType(logType);
                        parsedData.log.setUser(user);
                        break;
                    }
                    case 1: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XLog event name block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        String eventName = new String(subBlock.getData(), 0, subBlock.getData().length - 1);
                        parsedData.log.setEventName(eventName);
                        break;
                    }
                    case 32773: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XLog XLogData block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        this.parseXLogData(subBlock);
                        break;
                    }
                    case 32774: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XLog XMicrocodeLogData block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        this.parseXLogData(new SerializedBlock(subBlock.getData(), 0));
                        break;
                    }
                    default: {
                        Trace.trace(TRACE_MASKF, "Unknown XLog block type (" + subBlock.getType() + ")");
                    }
                }
                subBlockIx = (int)((long)subBlockIx + subBlock.getSize());
            }
        }
        Trace.trace(TRACE_MASKT, "<- HException.parseXLog()");
    }

    private void parseXLogData(SerializedBlock block) {
        Trace.trace(TRACE_MASKT, "-> HException.parseXLogData()");
        if (block.getType() != 32773) {
            Trace.trace(TRACE_MASKF, "Invalid XLogData data type (got " + block.getType() + ", expecting " + 32773 + ")");
        } else if (block.getFormat() != 1) {
            Trace.trace(TRACE_MASKF, "Invalid XLogData block data format (got " + block.getFormat() + ", expecting 1)");
        } else {
            int blockId = -1;
            byte[] blockData = null;
            int subBlockIx = 0;
            while (subBlockIx < block.getData().length) {
                SerializedBlock subBlock = new SerializedBlock(block.getData(), subBlockIx);
                switch (subBlock.getType()) {
                    case 0: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XLogData base block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        byte[] baseData = subBlock.getData();
                        byte[] blockIdData = new byte[]{baseData[1], baseData[0]};
                        blockId = BinaryNumber.toShort(blockIdData);
                        break;
                    }
                    case 1: {
                        if (subBlock.getFormat() != 1) {
                            Trace.trace(TRACE_MASKF, "Invalid XLogData data block format (got " + subBlock.getFormat() + ", expecting 1)");
                            break;
                        }
                        blockData = subBlock.getData();
                        break;
                    }
                    default: {
                        Trace.trace(TRACE_MASKF, "Unknown XLogData block type (" + subBlock.getType() + ")");
                    }
                }
                subBlockIx = (int)((long)subBlockIx + subBlock.getSize());
            }
            if (blockId != -1 && blockData != null) {
                if (blockId == 256) {
                    this.add(blockData);
                } else if (blockId == 257) {
                    this.add(new String(blockData, 0, blockData.length - 1));
                } else {
                    this.add((byte)blockId, blockData);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- HException.parseXLogData()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ParsedData {
        public long attributes = 0L;
        public String backTrace = "";
        public String locationInfo = "";
        public boolean owned = true;
        public MicrocodeLog log = null;

        protected ParsedData() {
        }
    }

    protected static class SerializedBlock {
        public static final int baseBlock = 0;
        public static final int textBlock = 1;
        public static final int locationBlock = 2;
        public static final int locFileBlock = 3;
        public static final int locFuncBlock = 4;
        public static final int locLineBlock = 5;
        public static final int mLogBaseBlock = 0;
        public static final int mLogTextBlock = 1;
        public static final int mLogBacktraceBlock = 2;
        public static final int logBaseBlock = 0;
        public static final int logEventNameBlock = 1;
        public static final int logDataBlock = 2;
        public static final int logDBaseBlock = 0;
        public static final int logDDataBlock = 1;
        public static final int XExceptionBlock = 32768;
        public static final int XTrapExceptionBlock = 32769;
        public static final int XLogBlock = 32770;
        public static final int XMicrocodeLogBlock = 32771;
        public static final int XEndMicrocodeLogBlock = 32772;
        public static final int XLogDataBlock = 32773;
        public static final int XMicrocodeLogDataBlock = 32774;
        public static final int XBoebMicrocodeLogBlock = 32775;
        public static final int XBaseExceptionBlock = 32776;
        private long size_ = 0L;
        private int type_ = 0;
        private int format_ = 0;
        private byte[] data_;

        public SerializedBlock(byte[] blockHeader, int startIx) {
            if (blockHeader.length < startIx + 8) {
                Trace.trace(HException.TRACE_MASKF, "Invalid block header.  Length=" + (blockHeader.length - startIx));
            } else {
                byte[] size = new byte[4];
                for (int ix = 0; ix < 4; ++ix) {
                    size[ix] = blockHeader[startIx + ix];
                }
                this.size_ = BinaryNumber.toUnsignedInt(BinaryNumber.swapByteOrder(size));
                byte[] type = new byte[]{blockHeader[startIx + 5], blockHeader[startIx + 4]};
                this.type_ = BinaryNumber.toUnsignedShort(type);
                byte[] format = new byte[]{blockHeader[startIx + 7], blockHeader[startIx + 6]};
                this.format_ = BinaryNumber.toUnsignedShort(format);
                if ((long)blockHeader.length < (long)startIx + this.size_) {
                    Trace.trace(HException.TRACE_MASKF, "Invalid block.  Length=" + (blockHeader.length - startIx) + ", expecting " + this.size_ + 8);
                } else {
                    byte[] data = new byte[(int)this.size_ - 8];
                    int ix = 0;
                    while ((long)ix < this.size_ - 8L) {
                        data[ix] = blockHeader[startIx + ix + 8];
                        ++ix;
                    }
                    this.data_ = data;
                }
            }
        }

        public long getSize() {
            return this.size_;
        }

        public int getType() {
            return this.type_;
        }

        public int getFormat() {
            return this.format_;
        }

        public byte[] getData() {
            return this.data_;
        }

        public String toString() {
            return super.toString() + "[type=" + HexString.toHex(this.type_, true) + ",format=" + this.format_ + ",size=" + this.size_ + "]";
        }
    }
}

